/*
 * multimon.h
 * 
 * Defines and misc data for multiple monitor support
 * 
 * Code under GNU public license
 * Copyright (c) 1995, 1996
 * 
 * Author: Zach R. Amsden (amsden+@andrew.cmu.edu)
 */

/* Configuration for mono consoles */
#define NUMBER_OF_MONITORS	2

#define monitor_1_type	        VIDEO_TYPE_VGAC  /* set to 0 for autodetect */
#define monitor_1_base_port	0  /* set to 0 for autodetect */
#define monitor_1_base_mem	0  /* set to 0 for autodetect */
#define monitor_1_first		1
#define monitor_1_last		1

#define monitor_2_type		VIDEO_TYPE_MDA /* can't autodetect 2nd monitor */
#define monitor_2_base_port	0
#define monitor_2_base_mem	0
#define monitor_2_first		9   /* set to VC  */
#define monitor_2_last		12
#define MDA_CURSOR_BUG

#define PRIMARY_MONITOR         0

#define monitor_type(X)	        monitor_##X##_type

unsigned long init_monitors (unsigned long);	/* Set up monitor data structures	*/
short map_vc_to_mon (unsigned int);		/* Map virtual console onto a monitor */

/* Monitor data struct */
struct monitor_data {
        char		m_display_desc[5];	/* Device description 			*/
   	unsigned long	m_video_type;		/* Type of display being used		*/
   	int		m_can_do_color;	 	/* Can monitor handle color?		*/
   	unsigned char	m_screen_mode; 		/* Current screen mode			*/
	unsigned long	m_video_num_columns;	/* # of columns 			*/
	unsigned long	m_video_num_lines;	/* # of rows				*/
	unsigned long	m_video_size_row;	/* data size of row			*/
	unsigned long	m_video_mem_base;	/* base of video mem			*/
	unsigned long	m_video_mem_term;	/* end of video mem			*/
	unsigned long	m_video_screen_size;	/* size of screen buf			*/
   	unsigned short  m_video_port_base;	/* base for io ports			*/
   	unsigned short	m_video_port_reg;  	/* Video controller register select	*/
   	unsigned short	m_video_port_val;	/* Video controller data		*/
   	short		m_last_vc;    		/* Number of virtual consoles		*/
   	short		m_first_vc;   		/* First virtual console		*/
   	short		m_current_vc;		/* Current virtual console		*/
	unsigned short	m__real_origin;
   	unsigned short	m__origin;		/* Offset of currently displayed screen	*/
   	unsigned short	m__scrollback_mode;	/* 1 means scrollback can wrap		*/
        unsigned char   m_hardscroll_enabled;
        unsigned long	m_blank_origin;
   	unsigned long	m_blank__origin;
   	unsigned long	m_unblank_origin;
   	short		m_got_screen;		/* Do we have a VC?			*/
   	int		m_console_blanked;	/* Which console is blanked?		*/
   	void 	(*set_pal) (int);			/* Generic set_palette 		*/
   	void	(*set_org) (int, unsigned short);	/* Generic __set_origin 	*/
   	void	(*hide_cur) (int);			/* Generic hide_cursor 		*/
   	void	(*set_cur) (int);			/* Generic set_cursor		*/
   	void	(*set_scr) (int, long);			/* Generic set_scrmem		*/
   	void	(*get_scr) (int);			/* Generic get_scrmem		*/
   	int	(*sg_font) (int, char *, int, int);	/* Generic set_get_font		*/
   	int	(*con_adjust) (int, unsigned long);	/* Generic con_adjust_height	*/
   	int	(*sg_cmap) (int, unsigned char *, int); /* Generic set_get_cmap		*/   
}; 

extern short current_monitor;			/* Monitor of fg_console */

extern struct monitor_data monitor[NUMBER_OF_MONITORS];


/* Maps all kernel references to current monitor                      */
/*   the m_ is necessary because of these defines, plus it helps sort */
/*   out explicit references to a specific screen 
 */
#define currvc_monitor		(vc_cons[currcons].d->vc_monitor)
#define cur_vc_mon(X)		(vc_cons[X].d->vc_monitor)
#define vidtype(X)		(monitor[cur_vc_mon(X)].m_video_type)
#define vidportreg(X)		(monitor[cur_vc_mon(X)].m_video_port_reg)
#define vidportval(X)		(monitor[cur_vc_mon(X)].m_video_port_val)
#define vidnumlines(X)		(monitor[cur_vc_mon(X)].m_video_num_lines)
#define vidnumcols(X)		(monitor[cur_vc_mon(X)].m_video_num_columns)
#define vidsizerow(X)		(monitor[cur_vc_mon(X)].m_video_size_row)
#define video_mem_base 		(monitor[currvc_monitor].m_video_mem_base)
#define video_mem_term 		(monitor[currvc_monitor].m_video_mem_term)
#define video_screen_size	(monitor[currvc_monitor].m_video_screen_size)
#define video_num_columns	(monitor[currvc_monitor].m_video_num_columns)
#define video_num_lines		(monitor[currvc_monitor].m_video_num_lines)
#define video_size_row		(monitor[currvc_monitor].m_video_size_row)
#define can_do_color		(monitor[currvc_monitor].m_can_do_color)
#define number_of_vcs		(monitor[currvc_monitor].m_number_of_vcs)
#define video_port_reg		(monitor[currvc_monitor].m_video_port_reg)
#define video_port_val		(monitor[currvc_monitor].m_video_port_val)
#define video_port_regm		(monitor[mon].m_video_port_reg)
#define video_port_valm		(monitor[mon].m_video_port_val)
#define video_mem_termm		(monitor[mon].m_video_mem_term)
#define video_mem_basem		(monitor[mon].m_video_mem_base)
#define video_type		(monitor[currvc_monitor].m_video_type)
#define current_vc		(monitor[currvc_monitor].m_current_vc)
#define __origin		(monitor[currvc_monitor].m__origin)
#define __real_origin		(monitor[currvc_monitor].m__real_origin)
#define has_wrapped		(monitor[currvc_monitor].m__scrollback_mode)
#define hardscroll_enabled	(monitor[currvc_monitor].m_hardscroll_enabled)
#define blank_origin		(monitor[currvc_monitor].m_blank_origin)
#define blank__origin		(monitor[currvc_monitor].m_blank__origin)
#define unblank_origin		(monitor[currvc_monitor].m_unblank_origin)
#define got_screen		(monitor[currvc_monitor].m_got_screen)
#define console_blanked		(monitor[currvc_monitor].m_console_blanked)

#define set_palette		(monitor[currvc_monitor].set_pal)
#define __set_origin		(monitor[currvc_monitor].set_org)
#define hide_cursor		(monitor[currvc_monitor].hide_cur)
#define set_cursor		(monitor[currvc_monitor].set_cur)
#define set_scrmem		(monitor[currvc_monitor].set_scr)
#define get_scrmem		(monitor[currvc_monitor].get_scr)
#define set_get_font		(monitor[currvc_monitor].sg_font)
#define con_adjust_height	(monitor[currvc_monitor].con_adjust)
#define set_get_cmap		(monitor[currvc_monitor].sg_cmap)
