/*
 * multimon.c
 * 
 * Defines and misc data for multiple monitor support
 * 
 * Code under GNU public license
 * Copyright (c) 1995, 199
 * 
 * Author: Zach R. Amsden (amsden+@andrew.cmu.edu)
 */

#include <linux/tty.h>
#include <asm/errno.h>
#include "multimon.h"

struct monitor_data monitor [NUMBER_OF_MONITORS];

short current_monitor = PRIMARY_MONITOR;

extern unsigned long vga_con_type_init (unsigned long, struct monitor_data *m);
extern char hs_disabled_by_init(void);

/* It would be nice to do this by using null pointers, but then
 * all code calling these functions would have to check null,
 * meaning major code changes for some .c files 
 * Or this could be overloaded in C++, but C++ is not kernel standard
 */
int unsupported_fnil(int i, unsigned long l)
{
   	return -EINVAL;
}

int unsupported_fnici(int  i, unsigned char * c, int j)
{
   	return -EINVAL;
}

int unsupported_fnicii(int i, char* c, int j, int k)
{
   	return -EINVAL;
}

void unsupportedi(int i)
{
}

void unsupportedil(int i, long l)
{
}

void unsupportedis(int i, unsigned short s)
{
}

/* Set up default handler functions and call con_type init */
unsigned long set_funcs(unsigned long kmem_start, int mon)
{
   		monitor[mon].set_pal = unsupportedi;
   		monitor[mon].set_org = unsupportedis;
   		monitor[mon].hide_cur = unsupportedi;
   		monitor[mon].set_cur = unsupportedi;
   		monitor[mon].set_scr = unsupportedil;
   	        monitor[mon].get_scr = unsupportedi;
   		monitor[mon].sg_font = unsupported_fnicii;
   		monitor[mon].con_adjust = unsupported_fnil;
   		monitor[mon].sg_cmap = unsupported_fnici;
   		monitor[mon].m__scrollback_mode = 0;
   		monitor[mon].m_got_screen = 0;
   		monitor[mon].m_console_blanked = 0;
   		if (monitor[mon].m_video_type == 0)
#ifdef CONFIG_TGA
     		    kmem_start = tga_con_type_init(kmem_start, &monitor[mon]);
#else
   		    kmem_start = vga_con_type_init(kmem_start, &monitor[mon]);
#endif
		else {
#ifdef CONFIG_TGA
		     if (monitor[mon].m_video_type == VIDEO_TYPE_TGAC)
		       kmem_start = tga_con_type_init(kmem_start, &monitor[mon]);
#endif
		     if (monitor[mon].m_video_type != VIDEO_TYPE_TGAC)
		       kmem_start = vga_con_type_init(kmem_start, &monitor[mon]);
		}
		monitor[mon].m__real_origin = monitor[mon].m__origin = 
                   monitor[mon].m_video_mem_base;
   		monitor[mon].m_current_vc = monitor[mon].m_first_vc - 1;
   		return kmem_start;
}


/* Set up monitor data structures */
unsigned long init_monitors(unsigned long kmem_start)
{
	   	monitor[0].m_video_type = monitor_type(1);
   		monitor[0].m_video_mem_base = monitor_1_base_mem;
   		monitor[0].m_video_port_base = monitor_1_base_port;
	   	monitor[0].m_first_vc = monitor_1_first;
	   	monitor[0].m_last_vc = monitor_1_last;
		monitor[0].m_hardscroll_enabled = (hs_disabled_by_init() ? 0 :
		  (monitor[0].m_video_type == VIDEO_TYPE_EGAC
		    || monitor[0].m_video_type == VIDEO_TYPE_VGAC
		    || monitor[0].m_video_type == VIDEO_TYPE_EGAM));
   		kmem_start = set_funcs(kmem_start, 0);
#ifdef monitor_2_type
	   	monitor[1].m_video_type = monitor_type(2);
   		monitor[1].m_video_mem_base = monitor_2_base_mem;
   		monitor[1].m_video_port_base = monitor_2_base_port;
	   	monitor[1].m_first_vc = monitor_2_first;
	   	monitor[1].m_last_vc = monitor_2_last;
		monitor[1].m_hardscroll_enabled = (hs_disabled_by_init() ? 0 :
		  (monitor[1].m_video_type == VIDEO_TYPE_EGAC
		    || monitor[1].m_video_type == VIDEO_TYPE_VGAC
		    || monitor[1].m_video_type == VIDEO_TYPE_EGAM));
   		kmem_start = set_funcs(kmem_start, 1);
#endif
#ifdef monitor_3_type
	   	monitor[2].m_video_type = monitor_type(3);
   		monitor[2].m_video_mem_base = monitor_3_base_mem;
   		monitor[2].m_video_port_base = monitor_3_base_port;
	   	monitor[2].m_first_vc = monitor_3_first;
	   	monitor[2].m_last_vc = monitor_3_last;
		monitor[2].m_hardscroll_enabled = (hs_disabled_by_init() ? 0 :
		  (monitor[2].m_video_type == VIDEO_TYPE_EGAC
		    || monitor[2].m_video_type == VIDEO_TYPE_VGAC
		    || monitor[2].m_video_type == VIDEO_TYPE_EGAM));
   		kmem_start = set_funcs(kmem_start, 2);
#endif
#ifdef monitor_4_type
	   	monitor[3].m_video_type = monitor_type(4);
   		monitor[3].m_video_mem_base = monitor_4_base_mem;
   		monitor[3].m_video_port_base = monitor_4_base_port;
	   	monitor[3].m_first_vc = monitor_4_first;
	   	monitor[3].m_last_vc = monitor_4_last;
		monitor[3].m_hardscroll_enabled = (hs_disabled_by_init() ? 0 :
		  (monitor[3].m_video_type == VIDEO_TYPE_EGAC
		    || monitor[3].m_video_type == VIDEO_TYPE_VGAC
		    || monitor[3].m_video_type == VIDEO_TYPE_EGAM));
   		kmem_start = set_funcs(kmem_start, 3);
#endif
   		return kmem_start;
}

/* Return monitor on which vc should map */
short map_vc_to_mon(unsigned int a_vc)
{
   	int i;
   	short mon = PRIMARY_MONITOR;
   
   	a_vc++;
     	for (i=0; i < NUMBER_OF_MONITORS; i++)
		if ((a_vc >= monitor[i].m_first_vc) 
	           && (a_vc <= monitor[i].m_last_vc)) mon = i;
	return mon;
}
